#version 330 core
out vec4 FragColor;

uniform vec2 u_resolution;
uniform float u_time;

vec2 N(float angle) 
{
	return vec2(sin(angle), cos(angle));
}

void main()
{
	//vec2 uv = vec2(gl_FragCoord.x - .5 * u_resolution.x, gl_FragCoord.y / u_resolution.y);
	vec2 uv = vec2(gl_FragCoord.xy - .5 * u_resolution.xy) / u_resolution.y;
	uv *= 1.25;	// zoom -> 1. -> zoom in and  2. -> zoom out
	vec3 color = vec3(0.0); 
	
	uv.x = abs(uv.x); // reflected x
	uv.y += tan((5./6.)*3.1415) * .5;
	vec2 n = N((5./6.) * 3.1415); 
	float d = dot(uv-vec2(.5, 0), n);
	uv -= n*max(0., d)*2;
	
	n = N((u_time < 50 ? (2./3.) * 3.1415 : (sin(u_time * 0.3))*(2./3.) * 3.1415));
	float scale = 1.;
	uv.x += .5;
	for(int i = 0; i<5; i++) 
	{
		uv *= 3.;
		scale *= 3.;
		uv.x -= 1.5; 	
		
		uv.x = abs(uv.x);
		uv.x -= .5;
		uv -= n*min(0., dot(uv, n))*2;
	
		
	}
	
	d = length(uv - vec2(clamp(uv.x, -1. , 1.), 0));
	color += smoothstep( 1./u_resolution.y, .0, d/scale); 

	if (u_time <= 57)
	{
	color.rg += uv / scale; 
	}
	if (u_time > 57 && u_time < 66)
	{
	color.rg += uv / scale;
	color += (uv.y/ 2 - (sin(u_time)));
	}
	if (u_time > 66 && u_time < 77)
	{
	color.rg += uv / scale;
	color += ((cos(uv.y))/ 0.3 - (sin(u_time)));
	}
	if (u_time > 77 && u_time < 87)
	{
	color.rg += uv / scale;
	color -= (sin(uv.x / 0.3) * uv.x);
	}
	if (u_time > 87)
	{
	color.rg += uv / scale;
	color.rb += (uv * 3 - (sin(-u_time)));
	}
	if (u_time > 76 )
	{
	color *= (cos(uv.y)/ 0.3 - (uv.x/2) * (tan(u_time)) * 0.3);
	}

	
	if (u_time < 57)
	{
	FragColor = vec4(sin(color), 1.0);
	}
	if (u_time > 57)
	{
	FragColor = vec4(color.x * 0.2, color.y * 0.2, color.z * 0.5, 1.0);
	}
	
}
